/*C**************************************************************************
* NAME:         kbd_4_4.c
*----------------------------------------------------------------------------
* Copyright (c) 2003 Atmel.
*----------------------------------------------------------------------------
* RELEASE:      c5131-usb-kbd-light-1_0_2      
* REVISION:     1.2     
*----------------------------------------------------------------------------
* PURPOSE: 
* This file contains the interface management for a 4x4 keyboard.
*****************************************************************************/

/*_____ I N C L U D E S ____________________________________________________*/

#include "config.h"
#include "kbd_4_4.h"
#include "modules\timer_soft\timer_soft.h"
#include FILE_BOARD_H


/*_____ M A C R O S ________________________________________________________*/

#define DEFAULT_SCAN_KEY_VALUE  0x00

/*_____ D E F I N I T I O N S ______________________________________________*/

Union16 idata  scan_key;
        Uchar  key_hit;

/*_____ D E C L A R A T I O N S ____________________________________________*/

/*F**************************************************************************
* NAME:     kbd_init
*----------------------------------------------------------------------------
* PARAMS:
*
* return:
*----------------------------------------------------------------------------
* PURPOSE: 
*   Keyboard controller initialization
*----------------------------------------------------------------------------
* EXAMPLE:
*----------------------------------------------------------------------------
* NOTE:
*----------------------------------------------------------------------------
* REQUIREMENTS:
*****************************************************************************/
void kbd_init()
{
  key_hit = FALSE;

  Kbd_low_level_detection();
   
  IO_COLUMN_1 = SELECT_COLUMN;
  IO_COLUMN_2 = SELECT_COLUMN;
  IO_COLUMN_3 = SELECT_COLUMN;
  IO_COLUMN_4 = SELECT_COLUMN;
}



/*F**************************************************************************
* NAME:     kbd_test_hit
*----------------------------------------------------------------------------
* PARAMS:
*
* return:
*----------------------------------------------------------------------------
* PURPOSE: 
*   This function scans the keyboard keys and update the scan_key word.
*   if a key is pressed, the key_hit bit is set to TRUE.
*----------------------------------------------------------------------------
* EXAMPLE:
*----------------------------------------------------------------------------
* NOTE:
*----------------------------------------------------------------------------
* REQUIREMENTS:
*****************************************************************************/
void kbd_test_hit(void)
{
Byte b,c;

  if (Kbd_key_detected())
  {
    Led_2_off();
    IO_COLUMN_1 = FREE_COLUMN;
    IO_COLUMN_2 = FREE_COLUMN;
    IO_COLUMN_3 = FREE_COLUMN;
    IO_COLUMN_4 = FREE_COLUMN;
    Kbd_reset_detected();
    tempo(TIMER_5_MS);            /* soft debouncing */
    IO_COLUMN_1 = SELECT_COLUMN;
    IO_COLUMN_2 = SELECT_COLUMN;
    IO_COLUMN_3 = SELECT_COLUMN;
    IO_COLUMN_4 = SELECT_COLUMN;
  
  if (Kbd_no_key_detected()) { return; }
  
    IO_COLUMN_1 = FREE_COLUMN;
    IO_COLUMN_2 = FREE_COLUMN;
    IO_COLUMN_3 = FREE_COLUMN;
    IO_COLUMN_4 = FREE_COLUMN;
    Kbd_reset_detected();
  
    IO_COLUMN_1 = SELECT_COLUMN;         /* SCAN COLUMN_1 */
    b = Kbd_flag();
    IO_COLUMN_1 = FREE_COLUMN;
    Kbd_reset_detected();
  
    IO_COLUMN_2 = SELECT_COLUMN;         /* SCAN COLUMN_2 */
    b |= Kbd_flag() >> 4;
    IO_COLUMN_2 = FREE_COLUMN;
    Kbd_reset_detected();
  
    IO_COLUMN_3 = SELECT_COLUMN;         /* SCAN COLUMN_3 */
    c = Kbd_flag();
    IO_COLUMN_3 = FREE_COLUMN;
    Kbd_reset_detected();
  
    IO_COLUMN_4 = SELECT_COLUMN;         /* SCAN COLUMN_4 */
    c |= Kbd_flag() >> 4;
    IO_COLUMN_4 = FREE_COLUMN;
    Kbd_reset_detected();
  
    scan_key.b[0]=b;
    scan_key.b[1]=c;
  
    key_hit = TRUE;
  
    IO_COLUMN_1 = SELECT_COLUMN;
    IO_COLUMN_2 = SELECT_COLUMN;
    IO_COLUMN_3 = SELECT_COLUMN;
    IO_COLUMN_4 = SELECT_COLUMN;
  }
  else
  { Led_2_on(); scan_key.w=DEFAULT_SCAN_KEY_VALUE;}
}

